<?php
session_start();
require 'db.php';

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$exam_name = $_GET['exam'] ?? 'jamb';

// Fetch exam info
$exam_result = $conn->query("SELECT * FROM exams WHERE exam_name='$exam_name' LIMIT 1");
$exam = $exam_result->fetch_assoc();
$exam_id = $exam['id'] ?? 0;

// Fetch subjects that have questions for this exam
$subjects = $conn->query("
    SELECT DISTINCT subject
    FROM questions
    WHERE exam_type='JAMB'
");

// Initialize variables
$selected_subject_id = $_POST['subject_id'] ?? null;
$selected_year = $_POST['year'] ?? null;
$success = '';
$quiz_submitted = false;
$feedback = [];


// Handle quiz submission
if(isset($_POST['submit_quiz']) && isset($_POST['answers'])){
    $score = 0;
    foreach($_POST['answers'] as $q_id => $answer){
        $q_res = $conn->query("SELECT question_text, option_a, option_b, option_c, option_d, correct_option FROM questions WHERE id=$q_id");
        $q = $q_res->fetch_assoc();
        $correct = strtolower($q['correct_option']);
        if(strtolower($answer) == $correct){
            $score++;
        } else {
            $feedback[] = [
                'question' => $q['question_text'],
                'your_answer' => strtoupper($answer),
                'correct_answer' => strtoupper($correct),
                'options' => [
                    'A' => $q['option_a'],
                    'B' => $q['option_b'],
                    'C' => $q['option_c'],
                    'D' => $q['option_d']
                ]
            ];
        }
    }

    // Save score
    $stmt = $conn->prepare("INSERT INTO mock_results (user_id, exam_id, score) VALUES (?,?,?)");
    $stmt->bind_param("iii", $_SESSION['user_id'], $exam_id, $score);
    $stmt->execute();
    $success = "You scored $score points!";
    $quiz_submitted = true;
}

// Fetch available years for selected subject
$available_years = [];
if($selected_subject_id){
    $year_res = $conn->query("
        SELECT DISTINCT year 
        FROM questions
        WHERE exam_type='JAMB' AND subject='$selected_subject_id'
        ORDER BY year ASC
    ");
    while($y = $year_res->fetch_assoc()){
        $available_years[] = $y['year'];
    }
}

// Fetch questions if subject and year selected and quiz not submitted
$questions = [];
if($selected_subject_id && $selected_year && !$quiz_submitted){
    $q_res = $conn->query("
        SELECT * FROM questions
        WHERE exam_type='JAMB' AND subject='$selected_subject_id' AND year='$selected_year'
        ORDER BY RAND()
    ");
    while($q = $q_res->fetch_assoc()){
        $questions[] = $q;
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo strtoupper($exam_name); ?> Quiz</title>
<link rel="stylesheet" href="../dist/css/style.css">
</head>
<body>
<div class="container mt-5">
    <h2><?php echo strtoupper($exam_name); ?> Quiz</h2>

    <?php if($success): ?>
        <div class="success-msg"><?php echo $success; ?></div>
    <?php endif; ?>

    <?php if(!$selected_subject_id): ?>
        <!-- Subject selection -->
        <form method="POST">
            <label>Select Subject:</label>
            <select name="subject_id" class="form-control mb-2" required>
                <option value="">--Select Subject--</option>
                <?php while($subject = $subjects->fetch_assoc()): ?>
                    <option value="<?php echo $subject['subject']; ?>"><?php echo ucfirst($subject['subject']); ?></option>
                <?php endwhile; ?>
            </select>
            <button type="submit" class="btn btn-warning">Next</button>
        </form>

    <?php elseif(!$selected_year && !$quiz_submitted): ?>
        <!-- Year selection -->
        <form method="POST">
            <input type="hidden" name="subject_id" value="<?php echo $selected_subject_id; ?>">
            <label>Select Year:</label>
            <select name="year" class="form-control mb-2" required>
                <option value="">--Select Year--</option>
                <?php foreach($available_years as $year): ?>
                    <option value="<?php echo $year; ?>"><?php echo $year; ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="btn btn-warning">Start Quiz</button>
        </form>

    <?php elseif(!$quiz_submitted): ?>
        <!-- Display quiz questions -->
        <form method="POST">
            <input type="hidden" name="subject_id" value="<?php echo $selected_subject_id; ?>">
            <input type="hidden" name="year" value="<?php echo $selected_year; ?>">
            <?php $i=1; foreach($questions as $q): ?>
                <div class="mb-3">
                    <p><strong>Q<?php echo $i++; ?>. <?php echo $q['question_text']; ?></strong></p>
                    <div class="form-check">
                        <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="a" required>
                        <label><?php echo $q['option_a']; ?></label>
                    </div>
                    <div class="form-check">
                        <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="b">
                        <label><?php echo $q['option_b']; ?></label>
                    </div>
                    <div class="form-check">
                        <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="c">
                        <label><?php echo $q['option_c']; ?></label>
                    </div>
                    <div class="form-check">
                        <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="d">
                        <label><?php echo $q['option_d']; ?></label>
                    </div>
                </div>
            <?php endforeach; ?>
            <button type="submit" name="submit_quiz" class="btn btn-success">Submit Quiz</button>
        </form>

    <?php else: ?>
        <!-- Show feedback after submission -->
        <h3>Your Feedback:</h3>
        <?php if(empty($feedback)): ?>
            <p>All answers correct! Well done 🎉</p>
        <?php else: ?>
            <?php foreach($feedback as $f): ?>
    <?php
        // Fetch explanation for this question
        $exp_res = $conn->query("SELECT explanation FROM questions WHERE question_text='". $conn->real_escape_string($f['question']) ."' LIMIT 1");
        $exp_row = $exp_res->fetch_assoc();
        $explanation = $exp_row['explanation'] ?? 'No explanation available';
    ?>
    <div class="feedback-card wrong">
        <p><strong>Q: <?php echo $f['question']; ?></strong></p>
        <p>Your answer: <?php echo $f['your_answer'] . ". " . $f['options'][$f['your_answer']]; ?></p>
        <p>Correct answer: <?php echo $f['correct_answer'] . ". " . $f['options'][$f['correct_answer']]; ?></p>
        <p><strong>Explanation:</strong> <?php echo $explanation; ?></p>
    </div>
<?php endforeach; ?>

        <?php endif; ?>
        <a href="takequiz.php?exam=<?php echo $exam_name; ?>" class="btn btn-warning">Take Another Quiz</a>
    <?php endif; ?>

</div>
<style>
/* ================== BODY ================== */
body {
    background: linear-gradient(135deg, #667eea, #764ba2);
    font-family: 'Poppins', sans-serif;
    margin: 0;
    padding: 0;
    color: #333;
}

/* ================== CONTAINER ================== */
.container {
    max-width: 900px;
    background: rgba(255,255,255,0.95);
    backdrop-filter: blur(15px);
    padding: 50px 35px;
    border-radius: 25px;
    box-shadow: 0 30px 60px rgba(0,0,0,0.25);
    margin: 60px auto;
    transition: all 0.3s ease;
}

.container:hover {
    transform: translateY(-5px);
}

/* ================== HEADER ================== */
h2 {
    text-align: center;
    margin-bottom: 40px;
    font-size: 2.5rem;
    font-weight: 800;
    color: #4b0082;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* ================== SUCCESS MESSAGE ================== */
.success-msg {
    text-align: center;
    font-size: 1.3em;
    padding: 18px;
    background: #d1fae5;
    color: #065f46;
    border-radius: 15px;
    margin-bottom: 25px;
    border-left: 6px solid #10b981;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
}

/* ================== QUESTION CARDS ================== */
.mb-3 {
    padding: 25px;
    border-radius: 20px;
    background: linear-gradient(145deg, #fdfbfb, #ebedee);
    border-left: 6px solid #764ba2;
    margin-bottom: 25px;
    transition: all 0.3s ease;
}

.mb-3:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.15);
}

/* ================== LABELS ================== */
label {
    font-weight: 600;
    display: block;
    margin-bottom: 8px;
    cursor: pointer;
}

/* ================== FORM SELECT ================== */
select.form-control {
    padding: 12px 18px;
    border-radius: 12px;
    border: 1px solid #ccc;
    font-size: 1rem;
    transition: all 0.3s ease;
}

select.form-control:focus {
    outline: none;
    border-color: #764ba2;
    box-shadow: 0 0 12px rgba(118,75,162,0.3);
}

/* ================== RADIO BUTTONS ================== */
.form-check {
    margin-bottom: 14px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.form-check input[type="radio"] {
    accent-color: #764ba2;
    width: 22px;
    height: 22px;
    cursor: pointer;
}

/* ================== BUTTONS ================== */
.btn-warning, .btn-success {
    width: 100%;
    padding: 16px 0;
    font-size: 1.2rem;
    font-weight: 700;
    border-radius: 15px;
    border: none;
    cursor: pointer;
    transition: all 0.4s ease;
}

.btn-warning {
    background: linear-gradient(135deg, #fbb034, #ffdd00);
    color: #fff;
}

.btn-warning:hover {
    background: linear-gradient(135deg, #ffdd00, #fbb034);
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.25);
}

.btn-success {
    background: linear-gradient(135deg, #43e97b, #38f9d7);
    color: #fff;
}

.btn-success:hover {
    background: linear-gradient(135deg, #38f9d7, #43e97b);
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.25);
}

/* ================== FEEDBACK ================== */
.feedback-card {
    padding: 20px;
    border-radius: 18px;
    margin-bottom: 20px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

.feedback-card.correct {
    background: #d1fae5;
    border-left: 6px solid #10b981;
}

.feedback-card.wrong {
    background: #fde2e2;
    border-left: 6px solid #ef4444;
}

.feedback-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.15);
}

/* ================== RESPONSIVE ================== */
@media (max-width: 768px) {
    .container {
        padding: 35px 20px;
        margin: 30px 15px;
    }
    h2 {
        font-size: 2rem;
    }
}
</style>

</body>
</html>
