<?php
session_start();
require 'db.php';

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$exam_name = $_GET['exam'] ?? 'jamb';

// Fetch exam
$exam_result = $conn->query("SELECT * FROM exams WHERE exam_name='$exam_name'");
$exam = $exam_result->fetch_assoc();
$exam_id = $exam['id'];

// Fetch subjects that actually have questions for this exam
$subjects = $conn->query("
    SELECT DISTINCT s.id, s.name 
    FROM subjects s
    JOIN questions q ON q.subject = s.id
    WHERE q.exam_type='$exam_id'
");


// Handle quiz submission
if(isset($_POST['submit_quiz'])){
    $score = 0;
    foreach($_POST['answers'] as $q_id => $answer){
        $q_res = $conn->query("SELECT correct_option FROM questions WHERE id=$q_id");
        $correct = $q_res->fetch_assoc()['correct_option'];
        if(strtolower($answer) == strtolower($correct)) $score++;

    }

    $stmt = $conn->prepare("INSERT INTO mock_results (user_id, exam_id, score) VALUES (?,?,?)");
    $stmt->bind_param("iii", $_SESSION['user_id'], $exam_id, $score);
    $stmt->execute();
    $success = "You scored $score points!";
}

// If subject selected
$selected_subject_id = $_POST['subject_id'] ?? null;
$selected_year = $_POST['year'] ?? null;

// Fetch available years for selected subject
$available_years = [];
if($selected_subject_id){
   $year_res = $conn->query("
    SELECT DISTINCT year 
    FROM questions 
    WHERE exam_type='$exam_id' AND subject='$selected_subject_id'
    ORDER BY year ASC
");

    while($y = $year_res->fetch_assoc()){
        $available_years[] = $y['year'];
    }
}

// Fetch questions if subject and year selected
if($selected_subject_id && $selected_year){
    $questions = $conn->query("
        SELECT * FROM questions 
        WHERE id='$exam_id' AND subject='$selected_subject_id' AND year='$selected_year' 
        ORDER BY RAND()
    ");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo strtoupper($exam_name); ?> Quiz</title>
<link rel="stylesheet" href="../dist/css/style.css">
</head>
<body>
<div class="container mt-5">
    <h2><?php echo strtoupper($exam_name); ?> Quiz</h2>

    <?php if(isset($success)) echo "<p style='color:green;'>$success</p>"; ?>

    <?php if(!$selected_subject_id): ?>
        <form method="POST">
            <label>Subject:</label>
            <select name="subject_id" class="form-control mb-2" required>
                <option value="">Select Subject</option>
                <?php while($subject = $subjects->fetch_assoc()): ?>
                    <option value="<?php echo $subject['id']; ?>"><?php echo $subject['name']; ?></option>
                <?php endwhile; ?>
            </select>

            <button type="submit" class="btn btn-warning">Next</button>
        </form>

    <?php elseif(!$selected_year): ?>
        <form method="POST">
            <input type="hidden" name="subject_id" value="<?php echo $selected_subject_id; ?>">
            <label>Year:</label>
            <select name="year" class="form-control mb-2" required>
                <option value="">Select Year</option>
                <?php foreach($available_years as $year): ?>
                    <option value="<?php echo $year; ?>"><?php echo $year; ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="btn btn-warning">Start Quiz</button>
        </form>

    <?php else: ?>
        <form method="POST">
            <?php $i=1; while($q = $questions->fetch_assoc()): ?>
                <div class="mb-3">
                    <p><strong>Q<?php echo $i++; ?>. <?php echo $q['question_text']; ?></strong></p>
                    <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="a" required> <?php echo $q['option_a']; ?><br>
                    <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="b"> <?php echo $q['option_b']; ?><br>
                    <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="c"> <?php echo $q['option_c']; ?><br>
                    <input type="radio" name="answers[<?php echo $q['id']; ?>]" value="d"> <?php echo $q['option_d']; ?><br>
                </div>
            <?php endwhile; ?>
            <button type="submit" name="submit_quiz" class="btn btn-success">Submit Quiz</button>
        </form>
    <?php endif; ?>
    
</div>
<style>
/* ================== BODY ================== */
body {
    background: linear-gradient(135deg, #667eea, #764ba2);
    font-family: 'Poppins', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 0;
    color: #333;
}

/* ================== CONTAINER ================== */
.container {
    max-width: 900px;
    background: #ffffffdd;
    backdrop-filter: blur(10px);
    padding: 40px 30px;
    border-radius: 20px;
    box-shadow: 0 20px 50px rgba(0,0,0,0.2);
    margin: 60px auto;
    transition: transform 0.3s ease;
}

.container:hover {
    transform: translateY(-5px);
}

/* ================== HEADER ================== */
h2 {
    text-align: center;
    margin-bottom: 40px;
    font-size: 2.2rem;
    font-weight: 700;
    color: #4b0082;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* ================== SUCCESS MESSAGE ================== */
.success-msg {
    text-align: center;
    font-size: 1.2em;
    padding: 15px;
    background: #d1fae5;
    color: #065f46;
    border-radius: 12px;
    margin-bottom: 25px;
    border-left: 5px solid #10b981;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

/* ================== QUESTION CARDS ================== */
.mb-3 {
    padding: 25px;
    border-radius: 15px;
    background: linear-gradient(145deg, #fdfbfb, #ebedee);
    border-left: 6px solid #764ba2;
    margin-bottom: 25px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.mb-3:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.1);
}

/* ================== LABELS ================== */
label {
    font-weight: 600;
    display: block;
    margin-bottom: 8px;
}

/* ================== FORM SELECT ================== */
select.form-select {
    padding: 12px 15px;
    border-radius: 10px;
    border: 1px solid #ccc;
    font-size: 1rem;
    transition: all 0.3s ease;
}

select.form-select:focus {
    outline: none;
    border-color: #764ba2;
    box-shadow: 0 0 10px rgba(118,75,162,0.3);
}

/* ================== RADIO BUTTONS ================== */
.form-check {
    margin-bottom: 12px;
    display: flex;
    align-items: center;
}

.form-check input[type="radio"] {
    accent-color: #764ba2;
    width: 20px;
    height: 20px;
    margin-right: 12px;
    cursor: pointer;
}

.form-check label {
    font-size: 1rem;
    cursor: pointer;
}

/* ================== BUTTONS ================== */
.btn-warning, .btn-success {
    width: 100%;
    padding: 14px 0;
    font-size: 1.1rem;
    font-weight: 700;
    border-radius: 12px;
    border: none;
    cursor: pointer;
    transition: all 0.4s ease;
}

.btn-warning {
    background: linear-gradient(135deg, #fbb034, #ffdd00);
    color: #fff;
}

.btn-warning:hover {
    background: linear-gradient(135deg, #ffdd00, #fbb034);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

.btn-success {
    background: linear-gradient(135deg, #43e97b, #38f9d7);
    color: #fff;
}

.btn-success:hover {
    background: linear-gradient(135deg, #38f9d7, #43e97b);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

/* ================== RESPONSIVE ================== */
@media (max-width: 768px) {
    .container {
        padding: 30px 20px;
        margin: 30px 15px;
    }
    h2 {
        font-size: 1.8rem;
    }
}

    </style>
</body>
</html>
