<?php
session_start();
if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Scholarships for SS3 Students</title>
<link rel="stylesheet" href="../dist/css/style.css">
<style>
/* ======== GENERAL ======== */
body {
    font-family: 'Poppins', sans-serif;
    margin: 0;
    padding: 0;
    background: #f5f7fa;
}
.container {
    max-width: 1200px;
    margin: 50px auto;
    padding: 20px;
}
h2 {
    text-align: center;
    color: #4b0082;
    margin-bottom: 40px;
}

/* ======== CARD STYLING ======== */
.scholarship-card {
    background: #fff;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: transform 0.3s, box-shadow 0.3s;
    margin-bottom: 30px;
}
.scholarship-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.15);
}
.scholarship-card img {
    width: 100%;
    height: 200px;
    object-fit: cover;
}
.scholarship-card .content {
    padding: 20px;
}
.scholarship-card h3 {
    margin-top: 0;
    color: #764ba2;
}
.scholarship-card p {
    color: #333;
    line-height: 1.6;
}
.scholarship-card a.btn {
    display: inline-block;
    margin-top: 15px;
    padding: 12px 20px;
    border-radius: 12px;
    text-decoration: none;
    color: #fff;
    font-weight: 600;
    transition: all 0.3s;
}
.btn-primary { background: #667eea; }
.btn-primary:hover { background: #5a67d8; }
.btn-secondary { background: #764ba2; }
.btn-secondary:hover { background: #5e3a9e; }

/* ======== GRID ======== */
.row {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}
.col-3 {
    flex: 0 0 25%;
}
@media (max-width: 992px) { .col-3 { flex: 0 0 50%; } }
@media (max-width: 600px) { .col-3 { flex: 0 0 100%; } }
</style>
</head>
<body>

<div class="container">
    <h2>Scholarship Opportunities for SS3 Students</h2>
<br>
        <a href="takequiz.php?exam=jamb" class="btn">JAMB</a>
        <a href="takequiz.php?exam=wassce" class="btn">WASSCE</a>
        <a href="takequiz.php?exam=neco" class="btn">NECO</a>
        <a href="takequiz.php?exam=gce" class="btn">GCE</a>
        <a href="takequiz.php" class="btn" style="background: linear-gradient(135deg,#fbb034,#ffdd00);">Take Mock Exam</a>

    <div class="row">
        <!-- Scholarship 1 -->
        <div class="col-3">
            <div class="scholarship-card">
                <img src="https://www.asuprepdigital.org/wp-content/uploads/2024/09/benefits-of-online-high-school-for-your-child-scaled.jpg" alt="JLD i-Academy">
                <div class="content">
                    <h3>JLD i-Academy Scholarship</h3>
                    <p>Free online classes for SS1–SS3 students. Includes WAEC/NECO/JAMB prep and career mentoring. Flexible and accessible for students anywhere.</p>
                    <a href="https://www.jldiacademy.com/scholarship-program?utm_source=chatgpt.com" target="_blank" class="btn btn-primary">Apply Now</a>
                </div>
            </div>
        </div>

        <!-- Scholarship 2 -->
        <div class="col-3">
            <div class="scholarship-card">
                <img src="https://www.ffindia.org/images/single_event_page/single-event-banner.png" alt="SOWEF Essay">
                <div class="content">
                    <h3>SOWEF Essay Competition</h3>
                    <p>Open to SS3 students in Nigeria. Win cash prizes (₦200k, ₦150k, ₦100k), UTME forms, and certificates by submitting a quality essay.</p>
                    <a href="https://scholarshipsandaid.org/2025/10/23/sowef-2025-essay-competition-for-secondary-school-students/?utm_source=chatgpt.com" target="_blank" class="btn btn-primary">Learn More</a>
                </div>
            </div>
        </div>

        <!-- Scholarship 3 -->
        <div class="col-3">
            <div class="scholarship-card">
                <img src="https://www.sdmesa.edu/about-mesa/mesa-foundation/images/scholarship-graphic-6.jpg" alt="School Foundation Awards">
                <div class="content">
                    <h3>School Foundation & Private School Awards</h3>
                    <p>Various scholarships in Nigeria for academic excellence in science, writing, and competitions. Cash prizes and recognition for top students.</p>
                    <a href="https://www.nigeriaprivateschools.com/index.php/en/post-detail/46/Scholarships-for-Private-School-Students-in-Nigeria?utm_source=chatgpt.com" target="_blank" class="btn btn-secondary">Explore</a>
                </div>
            </div>
        </div>

        <!-- Scholarship 4 -->
        <div class="col-3">
            <div class="scholarship-card">
                <img src="https://npr.brightspotcdn.com/dims4/default/b1a34a6/2147483647/strip/true/crop/1200x628%2B0%2B0/resize/880x461%21/quality/90/?url=http%3A%2F%2Fnpr-brightspot.s3.amazonaws.com%2Fbe%2F9c%2Fb878b2694ff193abd940ac6691eb%2Fhannah-lavender.jpg" alt="The School Fund">
                <div class="content">
                    <h3>The School Fund (International)</h3>
                    <p>Supports students worldwide with tuition, bursaries, and learning assistance. Ideal for low-income families seeking secondary school scholarships.</p>
                    <a href="https://en.wikipedia.org/wiki/The_School_Fund?utm_source=chatgpt.com" target="_blank" class="btn btn-secondary">Details</a>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
