<?php
session_start();
require 'db.php'; // Your DB connection

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch last 10 results per subject
$result = $conn->query("
    SELECT mr.score, e.exam_name, q.subject, mr.created_at 
    FROM mock_results mr 
    JOIN exams e ON mr.exam_id = e.id 
    JOIN questions q ON q.exam_type = e.exam_name
    WHERE mr.user_id = $user_id
    ORDER BY mr.created_at DESC
    LIMIT 50
");

$subjects = [];
$total_scores = [];
$total_attempts = 0;

// Organize by subject
while($row = $result->fetch_assoc()) {
    $sub = ucfirst($row['subject']);
    if(!isset($subjects[$sub])) {
        $subjects[$sub] = [];
    }
    $subjects[$sub][] = $row['score'];
    $total_scores[] = $row['score'];
    $total_attempts++;
}

// Function to get rating from score
function get_rating($score){
    if($score >= 80) return 'A';
    if($score >= 70) return 'B';
    if($score >= 60) return 'C';
    if($score >= 50) return 'D';
    return 'F';
}

// Overall average
$overall_avg = $total_attempts ? array_sum($total_scores)/$total_attempts : 0;
$overall_rating = get_rating($overall_avg);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard - Pass Exam</title>
<link rel="stylesheet" href="../dist/css/style.css">
<style>
body {
    background: linear-gradient(135deg,#667eea,#764ba2);
    font-family: 'Poppins', sans-serif;
    margin:0;
    padding:0;
    color:#333;
}
.container {
    max-width: 1000px;
    margin: 40px auto;
    padding: 40px;
    background: rgba(255,255,255,0.95);
    border-radius: 25px;
    box-shadow: 0 30px 60px rgba(0,0,0,0.25);
}
h2, h3 {
    text-align:center;
    color:#4b0082;
}
.subject-card {
    background: linear-gradient(145deg,#fdfbfb,#ebedee);
    border-left: 6px solid #764ba2;
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 15px 35px rgba(0,0,0,0.15);
    transition: all 0.3s ease;
}
.subject-card:hover {
    transform: translateY(-5px);
}
.badge {
    display: inline-block;
    padding: 5px 10px;
    border-radius: 12px;
    font-weight: bold;
    color: #fff;
}
.badge-A { background-color: #10b981; }
.badge-B { background-color: #3b82f6; }
.badge-C { background-color: #facc15; }
.badge-D { background-color: #f97316; }
.badge-F { background-color: #ef4444; }
.score-box {
    display:flex;
    justify-content: space-between;
    margin-bottom:5px;
    padding:10px;
    background:#fff;
    border-radius:10px;
    box-shadow:0 5px 15px rgba(0,0,0,0.1);
}
.btn {
    display:inline-block;
    padding:12px 20px;
    border:none;
    border-radius:12px;
    background: linear-gradient(135deg,#43e97b,#38f9d7);
    color:#fff;
    text-decoration:none;
    font-weight:bold;
    margin-top:20px;
    transition: all 0.3s ease;
}
.btn:hover {
    transform: translateY(-3px);
    box-shadow:0 10px 25px rgba(0,0,0,0.25);
}
</style>
</head>
<body>
<div class="container">
    <h2>Welcome, <?php echo $_SESSION['username']; ?></h2>

    <?php if($_SESSION['role'] == 'admin'): ?>
        <h3>Admin Panel</h3>
        <a href="upload_questions.php" class="btn">Upload Questions</a>
    <?php else: ?>
        <h3>Your Exam Dashboard</h3>
        <a href="takequiz.php?exam=jamb" class="btn">JAMB</a>
        <a href="takequiz.php?exam=wassce" class="btn">WASSCE</a>
        <a href="takequiz.php?exam=neco" class="btn">NECO</a>
        <a href="takequiz.php?exam=gce" class="btn">GCE</a>
        <a href="takequiz.php" class="btn" style="background: linear-gradient(135deg,#fbb034,#ffdd00);">Take Mock Exam</a>

        <h3 class="mt-4">Your Past Scores & Ratings</h3>
        <?php if(empty($subjects)): ?>
            <p>No results yet. Take a quiz to see your progress!</p>
        <?php else: ?>
            <?php foreach($subjects as $sub => $scores): 
                $avg = array_sum($scores)/count($scores);
                $rating = get_rating($avg);
            ?>
                <div class="subject-card">
                    <h4><?php echo $sub; ?> <span class="badge badge-<?php echo $rating; ?>"><?php echo $rating; ?></span></h4>
                    <?php foreach($scores as $idx => $s): ?>
                        <div class="score-box">
                            <span>Attempt <?php echo $idx+1; ?></span>
                            <span>Score: <?php echo $s; ?></span>
                        </div>
                    <?php endforeach; ?>
                    <p><strong>Average Score:</strong> <?php echo number_format($avg,2); ?> | <strong>Rating:</strong> <span class="badge badge-<?php echo $rating; ?>"><?php echo $rating; ?></span></p>
                </div>
            <?php endforeach; ?>

            <h3>Overall Rating: <span class="badge badge-<?php echo $overall_rating; ?>"><?php echo $overall_rating; ?></span></h3>
            <p>Based on your last <?php echo $total_attempts; ?> results, your overall average is <?php echo number_format($overall_avg,2); ?>.</p>
        <?php endif; ?>
    <?php endif; ?>

    <a href="logout.php" class="btn" style="background:#9ca3af;">Logout</a>
</div>
</body>
</html>
